<?php

function convert_pinyin($hanzi, $charset = 'utf-8')
{
    static $pinyin_tbl = null;
    if (is_null($pinyin_tbl))
    {
        $pinyin = file_get_contents('pinyin.js');
        $pinyin_tbl = json_decode($pinyin, true);
    }

    if (strtolower($charset) != 'utf-8')
        $hanzi = iconv($hanzi, $charset, 'utf-8');
    $hanzi = iconv_substr($hanzi, 0, 1, 'utf-8');

    if (isset($pinyin_tbl[$hanzi]))
        return $pinyin_tbl[$hanzi];
    else
        return array();
}

print_r(convert_pinyin("足"));
