<?php

function ubb2html($str){
    $str = htmlspecialchars($str, ENT_NOQUOTES);
    $pattern = array(
        "/\[b\](.+?)\[\/b\]/is", //1
        "/\[i\](.+?)\[\/i\]/is", //2
        "/\[u\](.+?)\[\/u\]/is", //3
        "/\[sup\](.+?)\[\/sup\]/is", //4
        "/\[sub\](.+?)\[\/sub\]/is", //5
        "/\[center\](.+?)\[\/center\]/is", //6
        "/\[code\](.+?)\[\/code\]/is", //7
        "/\[quote\](.+?)\[\/quote\]/is", //8
        "/\[span style=\"(.*?)\"\](.+?)\[\/span\]/is", //9
        '/\[img\\s+src=\"(.+?)\"\]/is', //10
        '/\[img\\s+src=\"(.+?)\"\\s+width=\"(.+?)\"\]/is', //11
        '/\[img\\s+src=\"(.+?)\"\\s+height=\"(.+?)\"\]/is', //12
        '/\[img\\s+src=\"(.+?)\"\\s+width=\"(.+?)\"\\s+height=\"(.+?)\"\]/is', //13
        '/\[img\\s+src=\"(.+?)\"\\s+height=\"(.+?)\"\\s+width=\"(.+?)\"\]/is', //14
        '/\[a\\s+href=\"(.+?)\"\](.+?)\[\/a\]/is', //15
        );
    $replace = array(
        "<b>\\1</b>", //1
        "<i>\\1</i>", //2
        "<u>\\1</u>", //3
        "<sup>\\1</sup>", //4
        "<sub>\\1</sub>", //5
        "<center>\\1</center>", //6
        "<div class=\"code\">\\1</div>", //7
        "<div class=\"quote\">\\1</div>", //8
        "<span style=\"\\1\">\\2</span>", //9
        "<img border=\"0\" src=\"\\1\"/>", //10
        "<img border=\"0\" src=\"\\1\" width=\"\\2\"/>", //11
        "<img border=\"0\" src=\"\\1\" height=\"\\2\"/>", //12
        "<img border=\"0\" src=\"\\1\" width=\"\\2\" height=\"\\3\"/>", //13
        "<img border=\"0\" src=\"\\1\" width=\"\\3\" height=\"\\2\"/>", //14
        "<a href=\"\\1\" target=\"_blank\">\\2</a>", //15
        );
    $str = preg_replace($pattern, $replace, $str);
    return $str;
}

?>
